#!/usr/bin/bash

docker load -i openvpn-client.tar

if [ ! -c "/dev/net/tun" ];then
	mkdir -p /dev/net
	mknod /dev/net/tun c 10 200 &>/dev/null && chmod 600 /dev/net/tun
	sleep 3s
fi

docker run -d \
--name ovpn-client \
--network=host \
--restart=always \
--privileged=true \
-v ./client.conf:/etc/openvpn/client.conf \
-v ./passwd:/etc/openvpn/passwd \
-v /dev/net/tun:/dev/net/tun \
linuxcc/openvpn-client:v1.1
